/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	pgpMemLockNT.h - PGP NT driver memory locking functions header file


	$Id: pgpMemLockNT.h,v 1.2 2000/02/01 17:55:59 pbj Exp $
____________________________________________________________________________*/

#ifndef _pgpMemLockNT_h
#define _pgpMemLockNT_h

// constants
//	number of list items that can be held in internal heap
#define NUMITEMSPERBLOCK	64

// typedefs
//	elements of list used to keep track of locked blocks
typedef struct _MEMLOCKITEM {
	struct _MEMLOCKITEM*	pitemNext;
	PEPROCESS				peProcess;
	PFILE_OBJECT			pfo;
	ULONG					ulPage;
	ULONG					ulNumPages;
	PMDL					pmdl;
} PGPMEMLOCKITEM, *PPGPMEMLOCKITEM;

//	block of such items
typedef struct _MEMLOCKBLOCK {
	struct _MEMLOCKBLOCK*	pblockNext;
	PGPMEMLOCKITEM			item[NUMITEMSPERBLOCK];
} PGPMEMLOCKBLOCK, *PPGPMEMLOCKBLOCK;

//	structure to hold all memlock data
typedef struct {
	PPGPMEMLOCKBLOCK		pblockHeap;
	PPGPMEMLOCKITEM			pitemFreeList;
	PPGPMEMLOCKITEM			pitemLockedList;
} PGPMEMLOCK, *PPGPMEMLOCK;

// macros
//	DbgPrint prints a message to the kernel debugging console
#ifndef PGPdbgPrint
#if PGP_DEBUG
#define PGPdbgPrint(arg) DbgPrint arg
#else
#define PGPdbgPrint(arg)
#endif

#if PGP_DEBUG && PGP_DEBUG_VERBOSE
#define PGPdbgVerbosePrint(arg)  DbgPrint arg
#else
#define PGPdbgVerbosePrint(arg)
#endif
#endif

// prototypes

ULONG
pgpMemlockInit (
    IN PPGPMEMLOCK		ppml);

VOID
pgpMemlockCleanup (
    IN PPGPMEMLOCK		ppml,
	IN PVOID			pCriticalSection);

VOID
pgpMemlockCleanupHandle (
    IN PPGPMEMLOCK		ppml,
    IN PFILE_OBJECT 	pfo,
	IN PVOID			pCriticalSection);

VOID
pgpMemlockProcessOperation (
	IN PPGPMEMLOCK			ppml,
    IN PPGPMEMLOCKSTRUCT	ppmls,
    IN PFILE_OBJECT			pfo,
    IN ULONG				ulStatusFlags,
	IN PVOID				pCriticalSection);

#endif //_pgpMemLockNT_h
